local t = Def.ActorFrame {};

-- A very useful table...
local eval_lines = {
	"W1",
	"W2",
	"W3",
	"W4",
	"W5",
	"Miss",
	"MaxCombo"
}

local eval_radar = {
	Types = { 'Holds', 'Rolls', 'Hands', 'Mines', 'Lifts' },
}

local grade_area_offset = 16
local fade_out_speed = 0.3
local fade_out_pause = 0.08

-- And a function to make even better use out of the table.
local function GetJLineValue(line, pl)
	if line == "Held" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetHoldNoteScores("HoldNoteScore_Held")
	elseif line == "MaxCombo" then
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):MaxCombo()
	else
		return STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetTapNoteScores("TapNoteScore_" .. line)
	end
	return "???"
end

-- You know what, we'll deal with getting the overall scores with a function too.
local function GetPlScore(pl, scoretype)
	local primary_score = FormatPercentScore(STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetPercentDancePoints())
	local secondary_score = STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetScore()
	
	if scoretype == "primary" then
		return primary_score
	else
		return secondary_score
	end
end

-- Combo graphs?
local function GraphDisplay( pn )
	local t = Def.GraphDisplay {
			InitCommand=function(self) self:Load("GraphDisplay") end;
			BeginCommand=function(self)
				local ss = SCREENMAN:GetTopScreen():GetStageStats();
				self:Set( ss, ss:GetPlayerStageStats(pn) );
				self:player( pn );
				local Line = self:GetChild("Line")
				Line:visible(false)
			end
		};
	return t;
end

local function ComboGraph( pn )
	local t = Def.ComboGraph {
			InitCommand=function(self) self:Load("ComboGraph") end;
			BeginCommand=function(self)
				local ss = SCREENMAN:GetTopScreen():GetStageStats();
				self:Set( ss, ss:GetPlayerStageStats(pn) );
				self:player( pn );
			end
		};
	return t;
end

-- #################################################
-- That's enough functions; let's get this done.

-- Shared portion.
local mid_pane = Def.ActorFrame {
	Def.Sprite {
		Texture="_pod";
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y+30)
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;		
	},	
	Def.Sprite {
		InitCommand=function(self)
			self:xy(_screen.cx,_screen.cy+8)
			local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
			if GAMESTATE:IsCourseMode() then
				if target:HasBanner() then
					self:Load(target:GetBannerPath())
					self:scaletoclipped(256,80):zoom(0.75)		
				else
					self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(256,80):zoom(0.75)
				end;
			else
				if target and target:HasJacket() then
					self:Load(target:GetJacketPath())
					self:scaletoclipped(174,174)	
				elseif target:HasBackground() then
					self:Load(target:GetBackgroundPath())
					self:scaletoclipped(174,174)	
				elseif target:HasBanner() then
					self:Load(target:GetBannerPath())
					self:scaletoclipped(256,80):zoom(0.75)		
				else
					self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(256,80):zoom(0.75)
				end;
			end;
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	},
	Def.BitmapText {
			Font="Common Normal",
			InitCommand=function(self)
				self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-109):diffuse(color("#FFFFFF")):zoom(0.5):maxwidth(180/0.5)
			end;
			Text=GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() or GAMESTATE:GetCurrentSong():GetDisplayMainTitle();
			OnCommand=function(self)
				if not GAMESTATE:IsCourseMode() then
					local song = GAMESTATE:GetCurrentSong();
					if song then
						if song:GetDisplaySubTitle() ~= "" then
							self:addy(-10)
						end
					end;
				end;
			end;
			OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
		},
		Def.BitmapText {
			Font="Common Normal",
			InitCommand=function(self)
				self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-103):zoom(0.4):maxwidth(180/0.4)
			end;
			Text=GAMESTATE:IsCourseMode() and "" or GAMESTATE:GetCurrentSong():GetDisplaySubTitle();
			OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
		},
};


t[#t+1] = mid_pane

if GAMESTATE:GetPlayMode() ~= "PlayMode_Rave" then
	for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
		t[#t+1] = StandardDecorationFromTable( "GraphDisplay" .. ToEnumShortString(pn), GraphDisplay(pn) );
		t[#t+1] = StandardDecorationFromTable( "ComboGraph" .. ToEnumShortString(pn), ComboGraph(pn) );
	end
end


-- #################################################
-- Time to deal with all of the player stats. ALL OF THEM.

local eval_parts = Def.ActorFrame {}

for ip, p in ipairs(GAMESTATE:GetHumanPlayers()) do
	-- Some things to help positioning
	local step_count_offs = string.find(p, "P1") and -165 or 165+64
	local grade_parts_offs = string.find(p, "P1") and -192 or 192
	local options_location = string.find(p, "P1") and SCREEN_CENTER_X-192 or SCREEN_CENTER_X+192
	local p_grade = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetGrade()

	-- Step counts.
	for i, v in ipairs(eval_lines) do
		local spacing = 21*i
		local cur_line = "JudgmentLine_" .. v

		eval_parts[#eval_parts+1] = Def.ActorFrame {
		InitCommand=function(self) 	self:x(_screen.cx + step_count_offs):y((_screen.cy/2.3)+(spacing)) end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
			-- BG
			--Def.Quad {
			--	InitCommand=function(self) self:zoomto(220,32):diffuse(BoostColor(ColorMidTone(JudgmentLineToColor(cur_line)),0.6)) end;
			--  OnCommand=function(self)
			--		self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(0.9)
			--	end;
			--};
			-- Item name
			Def.BitmapText {
				Font = "Common Normal",
				InitCommand=function(self) self:x(-104):zoom(0.5):diffuse(JudgmentLineToColor(cur_line))
					self:settext(ToUpper(JudgmentLineToLocalizedString(cur_line))):horizalign(left) end;
				OnCommand=function(self)
					self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(1)
				end;
			};
			-- Numbers numbers numbers!
			Def.BitmapText {
				Font = "Common Normal",
				InitCommand=function(self)
					self:diffuse(color("#FFFFFF"))
					self:zoom(0.5):diffusealpha(1.0):shadowlength(1):maxwidth(120):horizalign(right):x(47)
				end;
				OnCommand=function(self)
					self:settext(GetJLineValue(v, p))
					self:diffusealpha(0):sleep(0.1 * i):decelerate(0.6):diffusealpha(1)
				end;
			};
		};
	end
	

	-- Letter grade and associated parts.
	eval_parts[#eval_parts+1] = Def.Sprite{
			Texture=THEME:GetPathG("GradeDisplay", "Grade " .. p_grade);
			InitCommand=function(self)
				self:horizalign(center):xy(_screen.cx + grade_parts_offs,_screen.cy-51)		   
			end;
			OnCommand=function(self)
				self:diffusealpha(0):zoom(0.75):addx(-12):sleep(1.4):decelerate(0.6):diffusealpha(0.4):addx(12)
			end;
			OffCommand=function(self)
			    self:decelerate(0.4):diffusealpha(0):addy(4)
			end;
	};

	-- Primary score.
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common normal",
		InitCommand=function(self)
			self:horizalign(right):x(_screen.cx + (step_count_offs)+35):y(_screen.cy+50)
			self:diffuse(color("#B8DFF9")):zoom(0.5):shadowlength(1):maxwidth(180)
		end;
		OnCommand=function(self)
			self:settext(GetPlScore(p, "primary")):diffusealpha(0):sleep(1.4):decelerate(0.6):diffusealpha(1)
		end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	}	
	-- Options
	eval_parts[#eval_parts+1] = Def.BitmapText {
		Font = "Common Normal",
		InitCommand=function(self)
			self:vertalign(bottom):x(options_location):y(_screen.cy+200):wrapwidthpixels(160/0.4):maxwidth(160/0.4)
			self:diffuse(Color.White):zoom(0.4):diffusealpha(0.6)
		end;
		OnCommand=function(self)
			self:settext(GAMESTATE:GetPlayerState(p):GetPlayerOptionsString(0))
			end;
		OffCommand=function(self)
			self:decelerate(0.4):diffusealpha(0):addy(4)
		end;
	};

	-- Other stats (holds, mines, etc.)
	for i, rc_type in ipairs(eval_radar.Types) do
		local performance = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetRadarActual():GetValue( "RadarCategory_"..rc_type )
		local possible = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetRadarPossible():GetValue( "RadarCategory_"..rc_type )
		local label = THEME:GetString("RadarCategory", rc_type)
		local spacing = 19*i

		eval_parts[#eval_parts+1] = Def.ActorFrame {
			InitCommand=function(self) 	self:x(_screen.cx + step_count_offs):y((_screen.cy*1.30)+(spacing)) end;
			OnCommand=function(self)
				self:diffusealpha(0):sleep(0.1 * i):decelerate(0.5):diffusealpha(1)
			end;
			OffCommand=function(self)
				self:decelerate(0.4):diffusealpha(0):addy(4)
			end;
				-- Item name
				Def.BitmapText {
					Font = "Common normal",
					InitCommand=function(self)
						self:zoom(0.5):x(-96):horizalign(left):diffuse(color("#9D9E9D")):shadowlength(1):uppercase(true)
					end;
					BeginCommand=function(self)
						self:settext(label)
					end;
				};
				-- Value
				Def.BitmapText {
				Font = "Common normal",
				InitCommand=function(self)
					self:diffuse(color("#FFFFFF"))
					self:zoom(0.5):diffusealpha(1.0):shadowlength(1):maxwidth(120):horizalign(right):x(36)
				end;
				BeginCommand=function(self)
					self:settext(performance .. "/" .. possible)
				end
				};
		};
	end;
end

t[#t+1] = eval_parts;

for ip, p in ipairs(GAMESTATE:GetHumanPlayers()) do
	local grade_parts_offs = string.find(p, "P1") and -195 or 195
		-- Some things to help positioning
		t[#t+1] = LoadFont("Common normal") .. {
			InitCommand=function(self)
				self:horizalign(center):xy(_screen.cx + grade_parts_offs,_screen.cy-140)		   
				self:diffuse(color("#FFFFFF")):zoom(0.65):maxwidth(160)
			end;
			OnCommand=function(self) self:playcommand("Set") end;
			["CurrentSteps"..ToEnumShortString(p).."ChangedMessageCommand"]=function(self) self:playcommand("Set") end;
			ChangedLanguageDisplayMessageCommand=function(self) self:playcommand("Set") end;
			SetCommand=function(self)
			if GAMESTATE:IsCourseMode() ~= true then
				local steps_data = GAMESTATE:GetCurrentSteps(p)
				local song = GAMESTATE:GetCurrentSong();
				if song and steps_data ~= nil then
					local st = steps_data:GetStepsType();
					local diff = steps_data:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					self:settext(ToUpper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))) .. "  " .. steps_data:GetMeter());
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
				end
			else
				local course = GAMESTATE:GetCurrentCourse();
				local steps_data = GAMESTATE:GetCurrentTrail(p);
				if course and steps_data ~= nil then
					  local st = steps_data:GetStepsType();
					  local diff = steps_data:GetDifficulty();
					  local courseType = course:GetCourseType();
					  local cd = GetCustomDifficulty(st, diff, courseType);
					  self:settext(ToUpper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))));
					  self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
				end
			end;
			end;
			OffCommand=function(self)
				self:decelerate(0.4):diffusealpha(0):addy(4)
			end;
		};
end;

for ip, p in ipairs(GAMESTATE:GetHumanPlayers()) do
	-- Some things to help positioning
	local badge_offs = string.find(p, "P1") and -50 or 50
	-- bases (PB)
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+138):x(SCREEN_CENTER_X+(badge_offs)) end;
		Texture="badge_base";
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};	
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+138):x(SCREEN_CENTER_X+(badge_offs)):diffuse(PlayerColor(p)) end;
		Texture="_pb";
		OnCommand=function(self)
			local record = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetPersonalHighScoreIndex()
			local hasPersonalRecord = record ~= -1
			self:visible(hasPersonalRecord);
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};	
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+138):x(SCREEN_CENTER_X+(badge_offs)) end;
		Texture="_best";
		OnCommand=function(self)
			local record = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetPersonalHighScoreIndex()
			local hasPersonalRecord = record ~= -1
			self:visible(hasPersonalRecord);
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
	t[#t+1] = Def.BitmapText {
		Font = "Common Normal";
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+140):x(SCREEN_CENTER_X+(badge_offs)):zoom(0.75):strokecolor(color("#000000")) end;
		OnCommand=function(self)
			local record = STATSMAN:GetCurStageStats():GetPlayerStageStats(p):GetPersonalHighScoreIndex()
			local hasPersonalRecord = record ~= -1
			self:visible(hasPersonalRecord);
			self:settext("#" .. record+1)
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
	-- bases (FC)
	t[#t+1] = Def.Sprite {
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+178):x(SCREEN_CENTER_X+(badge_offs)) end;
		Texture="badge_base";
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
	t[#t+1] = Def.Sprite {
		Texture="_fc";
		InitCommand=function(self) self:y(SCREEN_CENTER_Y+178):x(SCREEN_CENTER_X+(badge_offs)) end;
		OnCommand=function(self)
				local plstats = STATSMAN:GetCurStageStats():GetPlayerStageStats(p)
				if (plstats:FullComboOfScore('TapNoteScore_W1') == true) then
					self:visible(true):diffuse(color("#5BA4DB"))
				elseif (plstats:FullComboOfScore('TapNoteScore_W2') == true) then
					self:visible(true):diffuse(color("#E9D571"))	
				elseif (plstats:FullComboOfScore('TapNoteScore_W3') == true) then
					self:visible(true):diffuse(color("#46EB4E"))
				else
					self:visible(false)
				end;
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};	
	end;

-- Stage count
if not GAMESTATE:IsCourseMode() then
	t[#t+1] = LoadActor(THEME:GetPathG("ScreenEvaluation", "StageDisplay")) .. {
		InitCommand=function(self) self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-142):visible(not GAMESTATE:HasEarnedExtraStage()):zoom(0.5) end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
else
	t[#t+1] = Def.BitmapText {
		Font="Common Normal",
		InitCommand=function(self) 
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-142) 
			self:diffuse(color("#CBDDF0")):zoom(0.5):maxwidth(180/0.5)
		end;
		OnCommand=function(self) self:playcommand("Set") end;
		SetCommand=function(self)
			local course = GAMESTATE:GetCurrentCourse()
			self:settext(CourseTypeToLocalizedString(course:GetCourseType()))
			-- StepMania is being stupid so we have to do this here;
			self:diffusealpha(0):smooth(0.3):diffusealpha(1);
		end;
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
end;

if GAMESTATE:HasEarnedExtraStage() then
	t[#t+1] =  Def.BitmapText {
		InitCommand=function(self) 
			self:x(SCREEN_CENTER_X):y(SCREEN_CENTER_Y-132):visible(not GAMESTATE:HasEarnedExtraStage()) 
			self:diffuse(color("#C54039")):zoom(0.5):maxwidth(180/0.5)
		end;
		Font="Common Normal";
		Text=ToUpper(THEME:GetString("ScreenEvaluation", "ExtraUnlocked"));
		OffCommand=function(self) self:decelerate(0.4):diffusealpha(0):addy(4) end;
	};
end;

--t[#t+1] = StandardDecorationFromFileOptional("LifeDifficulty","LifeDifficulty");
--t[#t+1] = StandardDecorationFromFileOptional("TimingDifficulty","TimingDifficulty");

return t;
